# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 3
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Rounds (1-3)
    if current_round == 1:
        return "D"
    elif current_round <= 3:
        return "C"
    
    # Mid Rounds (4-7)
    elif current_round <= 7:
        # Count opponent's defections in first 3 rounds
        opp_defects_first_3 = opp_history[:3].count("D")
        if opp_defects_first_3 <= 1:
            return "C"
        else:
            return opp_history[-1]
    
    # Late Rounds (8-10)
    else:
        total_rounds_so_far = len(opp_history)
        coop_rate = opp_history.count("C") / total_rounds_so_far if total_rounds_so_far > 0 else 0
        if coop_rate >= 0.7:
            return "D"
        else:
            return opp_history[-1]